-- phpMyAdmin SQL Dump
-- version 5.1.1
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Sep 28, 2023 at 07:21 AM
-- Server version: 10.4.22-MariaDB
-- PHP Version: 8.0.13

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `unis`
--

-- --------------------------------------------------------

--
-- Table structure for table `AcademicTerm`
--

CREATE TABLE `AcademicTerm` (
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Term` varchar(50) NOT NULL,
  `AdmissionYear` year(4) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `AcademicTerm`
--

INSERT INTO `AcademicTerm` (`AcademicTermID`, `Term`, `AdmissionYear`) VALUES
(0000000001, '1st Semester', 2024),
(0000000002, '2nd Semester', 2024),
(0000000003, 'Midyear', 2024);

-- --------------------------------------------------------

--
-- Table structure for table `accountlogs`
--

CREATE TABLE `accountlogs` (
  `AccountLogsID` bigint(10) NOT NULL,
  `EmailAddress` varchar(200) DEFAULT NULL,
  `DateTime` datetime DEFAULT NULL,
  `Remarks` varchar(300) DEFAULT NULL,
  `Action` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `activityvenue`
--

CREATE TABLE `activityvenue` (
  `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `admissionaccount`
--

CREATE TABLE `admissionaccount` (
  `EmailAddress` varchar(200) NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `assessmentfeessettings`
--

CREATE TABLE `assessmentfeessettings` (
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentFessCode` int(11) NOT NULL,
  `AssessmentSemester` varchar(45) NOT NULL,
  `AssessmentYearLevel` varchar(45) NOT NULL,
  `AssessmentSchoolYear` varchar(45) NOT NULL,
  `AssessmentType` varchar(200) NOT NULL,
  `AssessmentDescription` varchar(200) NOT NULL,
  `AssessmentAmount` float(15,2) NOT NULL,
  `AssessmentStatus` int(11) NOT NULL DEFAULT 1,
  `AssessmentEffectivity` varchar(100) NOT NULL,
  `ProgramlevelID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `campus`
--

CREATE TABLE `campus` (
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CampusName` varchar(300) NOT NULL,
  `CampusAddress` varchar(500) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `campus`
--

INSERT INTO `campus` (`CampusID`, `CampusName`, `CampusAddress`) VALUES
(0000000001, 'CSPC Main', 'Nabua, Cam Sur'),
(0000000002, 'CSPC Bula', 'Bula, Cam Sur');

-- --------------------------------------------------------

--
-- Table structure for table `citizenship`
--

CREATE TABLE `citizenship` (
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Citizenship` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `classtype`
--

CREATE TABLE `classtype` (
  `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ClassType` varchar(45) NOT NULL COMMENT 'Lab, Lec, Workshop'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `clearance`
--

CREATE TABLE `clearance` (
  `ClearanceID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `DeansIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `OSASIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `StudentCouncilIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `CashierIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `RegistrarIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `AccountingIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `PTAIsVerify` varchar(100) NOT NULL COMMENT 'Yes/No',
  `AlumniIsVerify` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `college`
--

CREATE TABLE `college` (
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CollegeDesc` varchar(450) NOT NULL,
  `CollegeAbbr` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `college`
--

INSERT INTO `college` (`CollegeID`, `CampusID`, `CollegeDesc`, `CollegeAbbr`) VALUES
(0000000001, 0000000001, 'College of Computer Studies', 'CCS'),
(0000000002, 0000000001, 'College of Engineering and Architecture', 'CEA');

-- --------------------------------------------------------

--
-- Table structure for table `course`
--

CREATE TABLE `course` (
  `CourseCode` varchar(30) NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseName` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `course`
--

INSERT INTO `course` (`CourseCode`, `ProgramID`, `CourseName`) VALUES
('CCCS 101', 0000000002, 'Artificial Intelligence'),
('CCCS 102', 0000000002, 'Computer Programming'),
('CCCS 103', 0000000002, 'Database Design'),
('CCIT101', 0000000001, 'Introduction to Computing'),
('CCIT102', 0000000001, 'Web Development'),
('CCIT103', 0000000001, 'Database Design');

-- --------------------------------------------------------

--
-- Table structure for table `coursecoreq`
--

CREATE TABLE `coursecoreq` (
  `CourseCoReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCoReq` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `courseplotting`
--

CREATE TABLE `courseplotting` (
  `CoursePlottingID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DayOfWeek` tinyint(1) NOT NULL,
  `StartTime` time NOT NULL,
  `EndTime` time NOT NULL,
  `EmployeeNo` varchar(30) NOT NULL,
  `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `courseprereq`
--

CREATE TABLE `courseprereq` (
  `CoursePreReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CoursePreReq` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `courseschedule`
--

CREATE TABLE `courseschedule` (
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCode` varchar(30) NOT NULL,
  `FacultyNo` varchar(30) NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Year` varchar(45) DEFAULT NULL,
  `Section` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `curriculum`
--

CREATE TABLE `curriculum` (
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumName` varchar(400) DEFAULT NULL,
  `CurriculumBOT` varchar(100) DEFAULT NULL,
  `Effectivity` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `curriculum`
--

INSERT INTO `curriculum` (`CurriculumID`, `ProgramID`, `CurriculumName`, `CurriculumBOT`, `Effectivity`) VALUES
(0000000001, 0000000001, 'BSIT 2023 Curriculum', '2023-04', 'August 2023'),
(0000000002, 0000000002, 'BSCS 2023 Curriculum', '2023-05', 'August 2023');

-- --------------------------------------------------------

--
-- Table structure for table `curriculumcourse`
--

CREATE TABLE `curriculumcourse` (
  `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CourseCode` varchar(30) NOT NULL,
  `Year` int(2) NOT NULL,
  `Term` varchar(50) NOT NULL,
  `LecUnits` int(1) NOT NULL,
  `LabUnits` int(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `curriculumcourse`
--

INSERT INTO `curriculumcourse` (`CurriculumCourseID`, `CurriculumID`, `CourseCode`, `Year`, `Term`, `LecUnits`, `LabUnits`) VALUES
(0000000001, 0000000001, 'CCIT101', 1, '1st', 2, 3),
(0000000002, 0000000001, 'CCIT102', 1, '2nd', 2, 3),
(0000000003, 0000000001, 'CCIT103', 2, '1st', 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `document`
--

CREATE TABLE `document` (
  `DocumentID` int(10) NOT NULL,
  `DocumentName` varchar(250) DEFAULT NULL,
  `DocumentDescription` varchar(400) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `documentrequirement`
--

CREATE TABLE `documentrequirement` (
  `DocumentRequirementID` int(10) NOT NULL,
  `DocumentID` int(10) DEFAULT NULL,
  `DocumentName` varchar(300) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `employee`
--

CREATE TABLE `employee` (
  `EmployeeNo` varchar(30) NOT NULL,
  `FirstName` varchar(350) DEFAULT NULL,
  `MiddleName` varchar(350) DEFAULT NULL,
  `LastName` varchar(350) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `fees`
--

CREATE TABLE `fees` (
  `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Amount` decimal(20,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `feetype`
--

CREATE TABLE `feetype` (
  `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeType` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `googleaccount`
--

CREATE TABLE `googleaccount` (
  `EmailAddress` varchar(200) NOT NULL,
  `StudentNo` varchar(100) NOT NULL,
  `EmployeeNo` varchar(30) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `grade`
--

CREATE TABLE `grade` (
  `GradeID` bigint(10) NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `CourseCode` varchar(30) DEFAULT NULL,
  `Grade` varchar(45) DEFAULT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `UserIDwhoinput` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `orgactivity`
--

CREATE TABLE `orgactivity` (
  `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ActivityName` varchar(300) DEFAULT NULL,
  `ActivityDateStart` datetime DEFAULT NULL,
  `ActivityDateEnd` datetime DEFAULT NULL,
  `ActivityType` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `organization`
--

CREATE TABLE `organization` (
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationName` varchar(300) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `orgofficer`
--

CREATE TABLE `orgofficer` (
  `OrgOfficerID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `otherfees`
--

CREATE TABLE `otherfees` (
  `OID` int(11) NOT NULL,
  `AssessmentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `OSemester` varchar(200) NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Description` varchar(100) NOT NULL,
  `Amount` float(15,2) NOT NULL,
  `AmountPaid` float(15,2) NOT NULL,
  `Status` varchar(100) NOT NULL COMMENT 'Paid/Unpiand/Partialpaid'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `payment`
--

CREATE TABLE `payment` (
  `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) NOT NULL,
  `PaymentDate` datetime NOT NULL,
  `Amount` decimal(20,2) NOT NULL,
  `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paymentitem`
--

CREATE TABLE `paymentitem` (
  `PaymentItemID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Quantity` int(5) NOT NULL,
  `SubTotal` decimal(30,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `paymenttype`
--

CREATE TABLE `paymenttype` (
  `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `PaymentType` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `program`
--

CREATE TABLE `program` (
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramDesc` varchar(450) NOT NULL,
  `ProgramAbbr` varchar(200) NOT NULL,
  `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DefaultCurriculumID` int(10) DEFAULT NULL COMMENT 'Default Curriculum for Program'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `program`
--

INSERT INTO `program` (`ProgramID`, `CollegeID`, `ProgramDesc`, `ProgramAbbr`, `ProgramLevelID`, `DefaultCurriculumID`) VALUES
(0000000001, 0000000001, 'Bachelor of Science in Information Technology', 'BSIT', 0000000001, NULL),
(0000000002, 0000000001, 'Bachelor of Science in Computer Science', 'BSCS', 0000000001, NULL),
(0000000003, 0000000001, 'Bachelor of Science in Information Science', 'BSIS', 0000000001, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `programlevel`
--

CREATE TABLE `programlevel` (
  `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `ProgramLevelName` varchar(250) NOT NULL,
  `ProgramLevelDesc` varchar(500) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `programlevel`
--

INSERT INTO `programlevel` (`ProgramLevelID`, `ProgramLevelName`, `ProgramLevelDesc`) VALUES
(0000000001, 'Undergraduate', '(Certificate and Bachelor Programs)'),
(0000000002, 'Graduate', '(Graduate Micro-Program, Graduate Certificate, Graduate Diploma, Master and Doctoral Programs)'),
(0000000003, 'Undergraduate Degree Transfer', '(current undergraduate students who want to transfer from one Bachelor\'s degree program to another)'),
(0000000004, 'Undergraduate Independent Student', '(Part-time studies only; Courses taken are not part of a degree or certificate.)'),
(0000000005, 'Undergraduate Visiting Student from another University', ''),
(0000000006, 'Undergraduate Microprogram', '');

-- --------------------------------------------------------

--
-- Table structure for table `scholarship`
--

CREATE TABLE `scholarship` (
  `ScholarshipID` int(10) NOT NULL,
  `ScholarshipName` varchar(300) DEFAULT NULL,
  `Sponsor` varchar(100) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `scholarshipsubsidy`
--

CREATE TABLE `scholarshipsubsidy` (
  `ScholarshipID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `ScholarshipDescription` varchar(250) NOT NULL,
  `ScholarshipSubsidy` float(15,2) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `statement_of_account_fees`
--

CREATE TABLE `statement_of_account_fees` (
  `ID` int(10) NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Date_create` datetime NOT NULL,
  `Colleg_ID` int(10) NOT NULL,
  `ProgramID` int(10) NOT NULL,
  `Student_year` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAcademicHistory`
--

CREATE TABLE `StudentAcademicHistory` (
  `StudentAcademicHistoryID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `SchoolName` varchar(500) NOT NULL,
  `FromDate` date NOT NULL,
  `ToDate` date NOT NULL,
  `Degree` varchar(45) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentadditionalinfo`
--

CREATE TABLE `studentadditionalinfo` (
  `StudentAdditionalInfo` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentaddress`
--

CREATE TABLE `studentaddress` (
  `Student_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `Country` varchar(45) DEFAULT NULL,
  `HouseNo` varchar(45) DEFAULT NULL,
  `Street` varchar(45) DEFAULT NULL,
  `Brgy` varchar(45) DEFAULT NULL,
  `Town` varchar(45) DEFAULT NULL,
  `Province` varchar(45) DEFAULT NULL,
  `Region` varchar(45) DEFAULT NULL,
  `AddressLine1` varchar(45) DEFAULT NULL,
  `AddressLine2` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmissionSubmission`
--

CREATE TABLE `StudentAdmissionSubmission` (
  `StudentAdmissionSubmissionID` int(10) NOT NULL,
  `StudentAdmissionID` varchar(100) DEFAULT NULL,
  `DateSubmitted` datetime DEFAULT NULL,
  `DocumentRequirementID` int(10) DEFAULT NULL,
  `StudentRequirementFilename` varchar(45) DEFAULT NULL,
  `isValid` tinyint(1) DEFAULT NULL,
  `EmployeeNo` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentadmission_account`
--

CREATE TABLE `studentadmission_account` (
  `EmailAddress` varchar(100) NOT NULL,
  `Password` varchar(500) NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmission_Address`
--

CREATE TABLE `StudentAdmission_Address` (
  `StudentAdmission_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) DEFAULT NULL,
  `Country` varchar(45) DEFAULT NULL,
  `HouseNo` varchar(45) DEFAULT NULL,
  `Street` varchar(45) DEFAULT NULL,
  `Brgy` varchar(45) DEFAULT NULL,
  `Town` varchar(45) DEFAULT NULL,
  `Province` varchar(45) DEFAULT NULL,
  `Region` varchar(45) DEFAULT NULL,
  `AddressLine1` varchar(45) DEFAULT NULL,
  `AddressLine2` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentAdmission_Application`
--

CREATE TABLE `StudentAdmission_Application` (
  `StudentAdmission_ApplicationID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `Remarks` varchar(250) NOT NULL,
  `DateCreated` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentassessmentfees`
--

CREATE TABLE `studentassessmentfees` (
  `FeesID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `AssessmentFessID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `Amount` float(15,2) NOT NULL,
  `AmountPaid` float(15,2) NOT NULL COMMENT 'Paid/Unpaids',
  `Status` varchar(100) NOT NULL COMMENT 'Paid/Unpaid/Partialpaid'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentcourseschedule`
--

CREATE TABLE `studentcourseschedule` (
  `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentNo` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentcurriculum`
--

CREATE TABLE `studentcurriculum` (
  `StudentNo` varchar(100) NOT NULL,
  `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `isCurrent` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentdocumentsubmission`
--

CREATE TABLE `studentdocumentsubmission` (
  `StudentDocumentSubmissionID` int(10) NOT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `DateSubmitted` datetime DEFAULT NULL,
  `DocumentRequirementID` int(10) DEFAULT NULL,
  `StudentRequirementFilename` varchar(45) DEFAULT NULL,
  `isValid` tinyint(1) DEFAULT NULL,
  `EmployeeNo` varchar(30) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentinfo`
--

CREATE TABLE `studentinfo` (
  `StudentNo` varchar(100) NOT NULL,
  `FirstName` varchar(350) NOT NULL,
  `MiddleName` varchar(350) NOT NULL,
  `LastName` varchar(350) NOT NULL,
  `SexAssignedAtBirth` tinyint(1) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `CitizenshipStatus` varchar(200) NOT NULL,
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `isTransferee` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentInfo_Admission`
--

CREATE TABLE `StudentInfo_Admission` (
  `StudentAdmissionID` varchar(100) NOT NULL,
  `FirstName` varchar(350) NOT NULL,
  `MiddleName` varchar(350) NOT NULL,
  `LastName` varchar(350) NOT NULL,
  `isMale` tinyint(1) NOT NULL,
  `DateOfBirth` date NOT NULL,
  `CitizenshipStatus` varchar(200) NOT NULL,
  `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentParentGuardian`
--

CREATE TABLE `StudentParentGuardian` (
  `StudentParentGuardian` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `SPGFirstName` varchar(350) NOT NULL,
  `SPGMiddleName` varchar(350) DEFAULT NULL,
  `SPGLastName` varchar(350) NOT NULL,
  `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `StudentProgramChoice`
--

CREATE TABLE `StudentProgramChoice` (
  `StudentProgramChoiceID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentAdmissionID` varchar(100) NOT NULL,
  `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `Priority` tinyint(1) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `studentscholarship`
--

CREATE TABLE `studentscholarship` (
  `StudentScholarshipID` int(10) NOT NULL,
  `ScholarshipID` int(10) DEFAULT NULL,
  `StudentNo` varchar(100) DEFAULT NULL,
  `AcademicYear` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `student_assessment`
--

CREATE TABLE `student_assessment` (
  `SAID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `StudentID` varchar(100) NOT NULL,
  `CollegeID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `ProgramID` int(11) UNSIGNED ZEROFILL NOT NULL,
  `SchoolYear` varchar(100) NOT NULL,
  `Semester` varchar(100) NOT NULL,
  `YearLevel` varchar(100) NOT NULL,
  `CourseSection` varchar(100) NOT NULL,
  `CourseCode` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `transaction`
--

CREATE TABLE `transaction` (
  `TransactionID` int(10) NOT NULL,
  `StudentNo` varchar(45) DEFAULT NULL,
  `TransactionDesc` varchar(45) DEFAULT NULL,
  `Office` varchar(45) DEFAULT NULL,
  `DateTime` datetime DEFAULT NULL,
  `TransactionRequirements` varchar(45) DEFAULT NULL,
  `TransactionPayment` varchar(45) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `typeofparentguardian`
--

CREATE TABLE `typeofparentguardian` (
  `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL,
  `TypeOfParentGuardian` varchar(250) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `venue`
--

CREATE TABLE `venue` (
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueDesc` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `venueavailability`
--

CREATE TABLE `venueavailability` (
  `VenueAvailabilityID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL,
  `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL,
  `DayOfWeek` tinyint(1) NOT NULL,
  `StartTime` time NOT NULL,
  `EndTime` time NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `version`
--

CREATE TABLE `version` (
  `VersionID` int(10) NOT NULL,
  `DateTime` datetime DEFAULT NULL,
  `VersionDesc` longtext NOT NULL,
  `ResponsiblePerson` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Indexes for dumped tables
--

--
-- Indexes for table `AcademicTerm`
--
ALTER TABLE `AcademicTerm`
  ADD PRIMARY KEY (`AcademicTermID`);

--
-- Indexes for table `accountlogs`
--
ALTER TABLE `accountlogs`
  ADD PRIMARY KEY (`AccountLogsID`),
  ADD KEY `fk_AccountLogs_GoogleAccount1_idx` (`EmailAddress`);

--
-- Indexes for table `activityvenue`
--
ALTER TABLE `activityvenue`
  ADD PRIMARY KEY (`OrgActivityID`,`VenueID`),
  ADD KEY `fk_ActivityVenue_OrgActiviy1_idx` (`OrgActivityID`),
  ADD KEY `fk_ActivityVenue_Venue1_idx` (`VenueID`);

--
-- Indexes for table `admissionaccount`
--
ALTER TABLE `admissionaccount`
  ADD PRIMARY KEY (`EmailAddress`),
  ADD KEY `fk_AdmissionAccount_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `assessmentfeessettings`
--
ALTER TABLE `assessmentfeessettings`
  ADD PRIMARY KEY (`AssessmentID`),
  ADD KEY `fk_AssessmentFeesSettings_ProgramLevel1_idx` (`ProgramlevelID`),
  ADD KEY `fk_AssessmentFeesSettings_Program1_idx` (`ProgramID`);

--
-- Indexes for table `campus`
--
ALTER TABLE `campus`
  ADD PRIMARY KEY (`CampusID`);

--
-- Indexes for table `citizenship`
--
ALTER TABLE `citizenship`
  ADD PRIMARY KEY (`CitizenshipID`);

--
-- Indexes for table `classtype`
--
ALTER TABLE `classtype`
  ADD PRIMARY KEY (`ClassTypeID`);

--
-- Indexes for table `clearance`
--
ALTER TABLE `clearance`
  ADD PRIMARY KEY (`ClearanceID`),
  ADD KEY `fk_Clearance_Student_Assessment1_idx` (`AssessmentID`);

--
-- Indexes for table `college`
--
ALTER TABLE `college`
  ADD PRIMARY KEY (`CollegeID`),
  ADD KEY `fk_College_Campus_idx` (`CampusID`);

--
-- Indexes for table `course`
--
ALTER TABLE `course`
  ADD PRIMARY KEY (`CourseCode`),
  ADD KEY `fk_Course_Program1_idx` (`ProgramID`);

--
-- Indexes for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  ADD PRIMARY KEY (`CourseCoReqID`),
  ADD KEY `fk_CourseCoReq_CurriculumCourse1_idx` (`CurriculumCourseID`);

--
-- Indexes for table `courseplotting`
--
ALTER TABLE `courseplotting`
  ADD PRIMARY KEY (`CoursePlottingID`),
  ADD KEY `fk_CourseRoomAssignment_CourseSchedule1_idx` (`CourseScheduleID`),
  ADD KEY `fk_CourseRoomLabAssignment_RoomLab1_idx` (`VenueID`),
  ADD KEY `fk_CoursePlotting_Faculty1_idx` (`EmployeeNo`),
  ADD KEY `fk_CoursePlotting_ClassType1_idx` (`ClassTypeID`);

--
-- Indexes for table `courseprereq`
--
ALTER TABLE `courseprereq`
  ADD PRIMARY KEY (`CoursePreReqID`),
  ADD KEY `fk_CoursePreReq_CurriculumCourse1_idx` (`CurriculumCourseID`);

--
-- Indexes for table `courseschedule`
--
ALTER TABLE `courseschedule`
  ADD PRIMARY KEY (`CourseScheduleID`),
  ADD KEY `fk_StudentCourse_Course1_idx` (`CourseCode`),
  ADD KEY `fk_CourseSchedule_AcademicTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `curriculum`
--
ALTER TABLE `curriculum`
  ADD PRIMARY KEY (`CurriculumID`),
  ADD KEY `fk_Curriculum_Program1_idx` (`ProgramID`);

--
-- Indexes for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  ADD PRIMARY KEY (`CurriculumCourseID`),
  ADD KEY `fk_CurriculumCourse_Curriculum1_idx` (`CurriculumID`),
  ADD KEY `fk_CurriculumCourse_Course1_idx` (`CourseCode`);

--
-- Indexes for table `document`
--
ALTER TABLE `document`
  ADD PRIMARY KEY (`DocumentID`);

--
-- Indexes for table `documentrequirement`
--
ALTER TABLE `documentrequirement`
  ADD PRIMARY KEY (`DocumentRequirementID`),
  ADD KEY `fk_DocumentRequirement_Document1_idx` (`DocumentID`);

--
-- Indexes for table `employee`
--
ALTER TABLE `employee`
  ADD PRIMARY KEY (`EmployeeNo`);

--
-- Indexes for table `fees`
--
ALTER TABLE `fees`
  ADD PRIMARY KEY (`FeeID`),
  ADD KEY `fk_Fees_Program1_idx` (`ProgramID`),
  ADD KEY `fk_Fees_FeeType1_idx` (`FeeTypeID`);

--
-- Indexes for table `feetype`
--
ALTER TABLE `feetype`
  ADD PRIMARY KEY (`FeeTypeID`);

--
-- Indexes for table `googleaccount`
--
ALTER TABLE `googleaccount`
  ADD PRIMARY KEY (`EmailAddress`),
  ADD KEY `fk_GoogleAccount_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_GoogleAccount_Employee1_idx` (`EmployeeNo`);

--
-- Indexes for table `grade`
--
ALTER TABLE `grade`
  ADD PRIMARY KEY (`GradeID`),
  ADD KEY `fk_Grade_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_Grade_Course1_idx` (`CourseCode`),
  ADD KEY `fk_Grade_AcademicTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `orgactivity`
--
ALTER TABLE `orgactivity`
  ADD PRIMARY KEY (`OrgActivityID`),
  ADD KEY `fk_OrgActiviy_Organization1_idx` (`OrganizationID`);

--
-- Indexes for table `organization`
--
ALTER TABLE `organization`
  ADD PRIMARY KEY (`OrganizationID`),
  ADD KEY `fk_Organization_Campus1_idx` (`CampusID`);

--
-- Indexes for table `orgofficer`
--
ALTER TABLE `orgofficer`
  ADD PRIMARY KEY (`OrgOfficerID`),
  ADD KEY `fk_OrgOfficer_Organization1_idx` (`OrganizationID`);

--
-- Indexes for table `otherfees`
--
ALTER TABLE `otherfees`
  ADD PRIMARY KEY (`OID`),
  ADD KEY `fk_OtherFees_Student_Assessment_fees_info1_idx` (`AssessmentID`);

--
-- Indexes for table `payment`
--
ALTER TABLE `payment`
  ADD PRIMARY KEY (`PaymentID`),
  ADD KEY `fk_Payment_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_Payment_PaymentType1_idx` (`PaymentTypeID`);

--
-- Indexes for table `paymentitem`
--
ALTER TABLE `paymentitem`
  ADD PRIMARY KEY (`PaymentItemID`),
  ADD KEY `fk_PaymentItem_Fees1_idx` (`FeeID`),
  ADD KEY `fk_PaymentItem_Payment1_idx` (`PaymentID`);

--
-- Indexes for table `paymenttype`
--
ALTER TABLE `paymenttype`
  ADD PRIMARY KEY (`PaymentTypeID`);

--
-- Indexes for table `program`
--
ALTER TABLE `program`
  ADD PRIMARY KEY (`ProgramID`),
  ADD KEY `fk_Program_College1_idx` (`CollegeID`),
  ADD KEY `fk_Program_ProgramLevel1_idx` (`ProgramLevelID`);

--
-- Indexes for table `programlevel`
--
ALTER TABLE `programlevel`
  ADD PRIMARY KEY (`ProgramLevelID`);

--
-- Indexes for table `scholarship`
--
ALTER TABLE `scholarship`
  ADD PRIMARY KEY (`ScholarshipID`);

--
-- Indexes for table `scholarshipsubsidy`
--
ALTER TABLE `scholarshipsubsidy`
  ADD PRIMARY KEY (`ScholarshipID`),
  ADD KEY `fk_ScholarshipSubsidy_Student_Assessment_fees_info1_idx` (`AssessmentID`);

--
-- Indexes for table `statement_of_account_fees`
--
ALTER TABLE `statement_of_account_fees`
  ADD PRIMARY KEY (`ID`,`Date_create`);

--
-- Indexes for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  ADD PRIMARY KEY (`StudentAcademicHistoryID`),
  ADD KEY `fk_StudentAcademicHistory_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `studentadditionalinfo`
--
ALTER TABLE `studentadditionalinfo`
  ADD PRIMARY KEY (`StudentAdditionalInfo`);

--
-- Indexes for table `studentaddress`
--
ALTER TABLE `studentaddress`
  ADD PRIMARY KEY (`Student_AddressID`),
  ADD KEY `fk_StudentAddress_StudentInfo1_idx` (`StudentNo`);

--
-- Indexes for table `StudentAdmissionSubmission`
--
ALTER TABLE `StudentAdmissionSubmission`
  ADD PRIMARY KEY (`StudentAdmissionSubmissionID`),
  ADD KEY `fk_StudentDocumentSubmission_DocumentRequirement1_idx` (`DocumentRequirementID`),
  ADD KEY `fk_StudentDocumentSubmission_Employee1_idx` (`EmployeeNo`),
  ADD KEY `fk_StudentAdmissionSubmission_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `studentadmission_account`
--
ALTER TABLE `studentadmission_account`
  ADD PRIMARY KEY (`EmailAddress`),
  ADD KEY `fk_StudentAdmission_Account_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  ADD PRIMARY KEY (`StudentAdmission_AddressID`),
  ADD KEY `fk_StudentAdmission_Address_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  ADD PRIMARY KEY (`StudentAdmission_ApplicationID`),
  ADD KEY `fk_StudentAdmission_Application_StudentInfo_Admission1_idx` (`StudentAdmissionID`),
  ADD KEY `fk_StudentAdmission_Application_AdmissionTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `studentassessmentfees`
--
ALTER TABLE `studentassessmentfees`
  ADD PRIMARY KEY (`FeesID`),
  ADD KEY `fk_StudentAssessmentfees_Assessment_fees_Settings1_idx` (`AssessmentFessID`),
  ADD KEY `fk_StudentAssessmentfees_Student_Assessment_fees_info1_idx` (`AssessmentID`);

--
-- Indexes for table `studentcourseschedule`
--
ALTER TABLE `studentcourseschedule`
  ADD PRIMARY KEY (`CourseScheduleID`,`StudentNo`),
  ADD KEY `fk_StudentYearCourse_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_StudentPYS_CourseSchedule1_idx` (`CourseScheduleID`);

--
-- Indexes for table `studentcurriculum`
--
ALTER TABLE `studentcurriculum`
  ADD PRIMARY KEY (`StudentNo`,`CurriculumID`),
  ADD KEY `fk_StudentCurriculum_Curriculum1_idx` (`CurriculumID`);

--
-- Indexes for table `studentdocumentsubmission`
--
ALTER TABLE `studentdocumentsubmission`
  ADD PRIMARY KEY (`StudentDocumentSubmissionID`),
  ADD KEY `fk_StudentRequirement_StudentInfo1_idx` (`StudentNo`),
  ADD KEY `fk_StudentDocumentSubmission_DocumentRequirement1_idx` (`DocumentRequirementID`),
  ADD KEY `fk_StudentDocumentSubmission_Employee1_idx` (`EmployeeNo`);

--
-- Indexes for table `studentinfo`
--
ALTER TABLE `studentinfo`
  ADD PRIMARY KEY (`StudentNo`),
  ADD KEY `fk_StudentInfo_Citizenship1_idx` (`CitizenshipID`);

--
-- Indexes for table `StudentInfo_Admission`
--
ALTER TABLE `StudentInfo_Admission`
  ADD PRIMARY KEY (`StudentAdmissionID`),
  ADD KEY `fk_StudentInfo_Admission_Citizenship1_idx` (`CitizenshipID`);

--
-- Indexes for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  ADD PRIMARY KEY (`StudentParentGuardian`),
  ADD KEY `fk_StudentParentGuardian_TypeOfParentGuardian1_idx` (`TypeOfPGid`),
  ADD KEY `fk_StudentParentGuardian_StudentInfo_Admission1_idx` (`StudentAdmissionID`);

--
-- Indexes for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  ADD PRIMARY KEY (`StudentProgramChoiceID`),
  ADD KEY `fk_StudentProgramChoice_StudentInfo_Admission1_idx` (`StudentAdmissionID`),
  ADD KEY `fk_StudentProgramChoice_Program1_idx` (`ProgramID`);

--
-- Indexes for table `studentscholarship`
--
ALTER TABLE `studentscholarship`
  ADD PRIMARY KEY (`StudentScholarshipID`),
  ADD KEY `fk_StudentScholarship_Scholarship1_idx` (`ScholarshipID`),
  ADD KEY `fk_StudentScholarship_StudentInfo1_idx` (`StudentNo`);

--
-- Indexes for table `student_assessment`
--
ALTER TABLE `student_assessment`
  ADD PRIMARY KEY (`SAID`),
  ADD KEY `fk_Student_Assessment_fees_StudentInfo1_idx` (`StudentID`),
  ADD KEY `fk_Student_Assessment_fees_info_College1_idx` (`CollegeID`),
  ADD KEY `fk_Student_Assessment_fees_info_Program1_idx` (`ProgramID`);

--
-- Indexes for table `transaction`
--
ALTER TABLE `transaction`
  ADD PRIMARY KEY (`TransactionID`),
  ADD KEY `fk_Transaction_StudentInfo1_idx` (`StudentNo`);

--
-- Indexes for table `typeofparentguardian`
--
ALTER TABLE `typeofparentguardian`
  ADD PRIMARY KEY (`TypeOfPGid`);

--
-- Indexes for table `venue`
--
ALTER TABLE `venue`
  ADD PRIMARY KEY (`VenueID`);

--
-- Indexes for table `venueavailability`
--
ALTER TABLE `venueavailability`
  ADD PRIMARY KEY (`VenueAvailabilityID`),
  ADD KEY `fk_RoomLabAvailability_RoomLab1_idx` (`VenueID`),
  ADD KEY `fk_RoomLabAvailability_AcademicTerm1_idx` (`AcademicTermID`);

--
-- Indexes for table `version`
--
ALTER TABLE `version`
  ADD PRIMARY KEY (`VersionID`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `AcademicTerm`
--
ALTER TABLE `AcademicTerm`
  MODIFY `AcademicTermID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `assessmentfeessettings`
--
ALTER TABLE `assessmentfeessettings`
  MODIFY `AssessmentID` int(11) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `campus`
--
ALTER TABLE `campus`
  MODIFY `CampusID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `citizenship`
--
ALTER TABLE `citizenship`
  MODIFY `CitizenshipID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `classtype`
--
ALTER TABLE `classtype`
  MODIFY `ClassTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `college`
--
ALTER TABLE `college`
  MODIFY `CollegeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  MODIFY `CourseCoReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `courseplotting`
--
ALTER TABLE `courseplotting`
  MODIFY `CoursePlottingID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `courseprereq`
--
ALTER TABLE `courseprereq`
  MODIFY `CoursePreReqID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `courseschedule`
--
ALTER TABLE `courseschedule`
  MODIFY `CourseScheduleID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `curriculum`
--
ALTER TABLE `curriculum`
  MODIFY `CurriculumID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=3;

--
-- AUTO_INCREMENT for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  MODIFY `CurriculumCourseID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `fees`
--
ALTER TABLE `fees`
  MODIFY `FeeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `feetype`
--
ALTER TABLE `feetype`
  MODIFY `FeeTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `orgactivity`
--
ALTER TABLE `orgactivity`
  MODIFY `OrgActivityID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `organization`
--
ALTER TABLE `organization`
  MODIFY `OrganizationID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `orgofficer`
--
ALTER TABLE `orgofficer`
  MODIFY `OrgOfficerID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `otherfees`
--
ALTER TABLE `otherfees`
  MODIFY `OID` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `payment`
--
ALTER TABLE `payment`
  MODIFY `PaymentID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paymentitem`
--
ALTER TABLE `paymentitem`
  MODIFY `PaymentItemID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `paymenttype`
--
ALTER TABLE `paymenttype`
  MODIFY `PaymentTypeID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `program`
--
ALTER TABLE `program`
  MODIFY `ProgramID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=4;

--
-- AUTO_INCREMENT for table `programlevel`
--
ALTER TABLE `programlevel`
  MODIFY `ProgramLevelID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=7;

--
-- AUTO_INCREMENT for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  MODIFY `StudentAcademicHistoryID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `studentaddress`
--
ALTER TABLE `studentaddress`
  MODIFY `Student_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  MODIFY `StudentAdmission_AddressID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  MODIFY `StudentAdmission_ApplicationID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  MODIFY `StudentParentGuardian` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  MODIFY `StudentProgramChoiceID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `typeofparentguardian`
--
ALTER TABLE `typeofparentguardian`
  MODIFY `TypeOfPGid` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `venue`
--
ALTER TABLE `venue`
  MODIFY `VenueID` int(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `venueavailability`
--
ALTER TABLE `venueavailability`
  MODIFY `VenueAvailabilityID` bigint(10) UNSIGNED ZEROFILL NOT NULL AUTO_INCREMENT;

--
-- Constraints for dumped tables
--

--
-- Constraints for table `accountlogs`
--
ALTER TABLE `accountlogs`
  ADD CONSTRAINT `fk_AccountLogs_GoogleAccount1` FOREIGN KEY (`EmailAddress`) REFERENCES `googleaccount` (`EmailAddress`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `activityvenue`
--
ALTER TABLE `activityvenue`
  ADD CONSTRAINT `fk_ActivityVenue_OrgActiviy1` FOREIGN KEY (`OrgActivityID`) REFERENCES `orgactivity` (`OrgActivityID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_ActivityVenue_Venue1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `admissionaccount`
--
ALTER TABLE `admissionaccount`
  ADD CONSTRAINT `fk_AdmissionAccount_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `assessmentfeessettings`
--
ALTER TABLE `assessmentfeessettings`
  ADD CONSTRAINT `fk_AssessmentFeesSettings_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_AssessmentFeesSettings_ProgramLevel1` FOREIGN KEY (`ProgramlevelID`) REFERENCES `programlevel` (`ProgramLevelID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `clearance`
--
ALTER TABLE `clearance`
  ADD CONSTRAINT `fk_Clearance_Student_Assessment1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `college`
--
ALTER TABLE `college`
  ADD CONSTRAINT `fk_College_Campus` FOREIGN KEY (`CampusID`) REFERENCES `campus` (`CampusID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `course`
--
ALTER TABLE `course`
  ADD CONSTRAINT `fk_Course_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `coursecoreq`
--
ALTER TABLE `coursecoreq`
  ADD CONSTRAINT `fk_CourseCoReq_CurriculumCourse1` FOREIGN KEY (`CurriculumCourseID`) REFERENCES `curriculumcourse` (`CurriculumCourseID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `courseplotting`
--
ALTER TABLE `courseplotting`
  ADD CONSTRAINT `fk_CoursePlotting_ClassType1` FOREIGN KEY (`ClassTypeID`) REFERENCES `classtype` (`ClassTypeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CoursePlotting_Faculty1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CourseRoomAssignment_CourseSchedule1` FOREIGN KEY (`CourseScheduleID`) REFERENCES `courseschedule` (`CourseScheduleID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CourseRoomLabAssignment_RoomLab1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `courseprereq`
--
ALTER TABLE `courseprereq`
  ADD CONSTRAINT `fk_CoursePreReq_CurriculumCourse1` FOREIGN KEY (`CurriculumCourseID`) REFERENCES `curriculumcourse` (`CurriculumCourseID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `courseschedule`
--
ALTER TABLE `courseschedule`
  ADD CONSTRAINT `fk_CourseSchedule_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentCourse_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `curriculum`
--
ALTER TABLE `curriculum`
  ADD CONSTRAINT `fk_Curriculum_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `curriculumcourse`
--
ALTER TABLE `curriculumcourse`
  ADD CONSTRAINT `fk_CurriculumCourse_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_CurriculumCourse_Curriculum1` FOREIGN KEY (`CurriculumID`) REFERENCES `curriculum` (`CurriculumID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `documentrequirement`
--
ALTER TABLE `documentrequirement`
  ADD CONSTRAINT `fk_DocumentRequirement_Document1` FOREIGN KEY (`DocumentID`) REFERENCES `document` (`DocumentID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `fees`
--
ALTER TABLE `fees`
  ADD CONSTRAINT `fk_Fees_FeeType1` FOREIGN KEY (`FeeTypeID`) REFERENCES `feetype` (`FeeTypeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Fees_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `googleaccount`
--
ALTER TABLE `googleaccount`
  ADD CONSTRAINT `fk_GoogleAccount_Employee1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_GoogleAccount_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `grade`
--
ALTER TABLE `grade`
  ADD CONSTRAINT `fk_Grade_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Grade_Course1` FOREIGN KEY (`CourseCode`) REFERENCES `course` (`CourseCode`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Grade_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `orgactivity`
--
ALTER TABLE `orgactivity`
  ADD CONSTRAINT `fk_OrgActiviy_Organization1` FOREIGN KEY (`OrganizationID`) REFERENCES `organization` (`OrganizationID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `organization`
--
ALTER TABLE `organization`
  ADD CONSTRAINT `fk_Organization_Campus1` FOREIGN KEY (`CampusID`) REFERENCES `campus` (`CampusID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `orgofficer`
--
ALTER TABLE `orgofficer`
  ADD CONSTRAINT `fk_OrgOfficer_Organization1` FOREIGN KEY (`OrganizationID`) REFERENCES `organization` (`OrganizationID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `otherfees`
--
ALTER TABLE `otherfees`
  ADD CONSTRAINT `fk_OtherFees_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `payment`
--
ALTER TABLE `payment`
  ADD CONSTRAINT `fk_Payment_PaymentType1` FOREIGN KEY (`PaymentTypeID`) REFERENCES `paymenttype` (`PaymentTypeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Payment_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `paymentitem`
--
ALTER TABLE `paymentitem`
  ADD CONSTRAINT `fk_PaymentItem_Fees1` FOREIGN KEY (`FeeID`) REFERENCES `fees` (`FeeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_PaymentItem_Payment1` FOREIGN KEY (`PaymentID`) REFERENCES `payment` (`PaymentID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `program`
--
ALTER TABLE `program`
  ADD CONSTRAINT `fk_Program_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_Program_ProgramLevel1` FOREIGN KEY (`ProgramLevelID`) REFERENCES `programlevel` (`ProgramLevelID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `scholarshipsubsidy`
--
ALTER TABLE `scholarshipsubsidy`
  ADD CONSTRAINT `fk_ScholarshipSubsidy_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `StudentAcademicHistory`
--
ALTER TABLE `StudentAcademicHistory`
  ADD CONSTRAINT `fk_StudentAcademicHistory_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentaddress`
--
ALTER TABLE `studentaddress`
  ADD CONSTRAINT `fk_StudentAddress_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentAdmissionSubmission`
--
ALTER TABLE `StudentAdmissionSubmission`
  ADD CONSTRAINT `fk_StudentAdmissionSubmission_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentDocumentSubmission_DocumentRequirement10` FOREIGN KEY (`DocumentRequirementID`) REFERENCES `documentrequirement` (`DocumentRequirementID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentDocumentSubmission_Employee10` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentadmission_account`
--
ALTER TABLE `studentadmission_account`
  ADD CONSTRAINT `fk_StudentAdmission_Account_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentAdmission_Address`
--
ALTER TABLE `StudentAdmission_Address`
  ADD CONSTRAINT `fk_StudentAdmission_Address_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentAdmission_Application`
--
ALTER TABLE `StudentAdmission_Application`
  ADD CONSTRAINT `fk_StudentAdmission_Application_AdmissionTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentAdmission_Application_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentassessmentfees`
--
ALTER TABLE `studentassessmentfees`
  ADD CONSTRAINT `fk_StudentAssessmentfees_Assessment_fees_Settings1` FOREIGN KEY (`AssessmentFessID`) REFERENCES `assessmentfeessettings` (`AssessmentID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_StudentAssessmentfees_Student_Assessment_fees_info1` FOREIGN KEY (`AssessmentID`) REFERENCES `student_assessment` (`SAID`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `studentcourseschedule`
--
ALTER TABLE `studentcourseschedule`
  ADD CONSTRAINT `fk_StudentPYS_CourseSchedule1` FOREIGN KEY (`CourseScheduleID`) REFERENCES `courseschedule` (`CourseScheduleID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentYearCourse_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentcurriculum`
--
ALTER TABLE `studentcurriculum`
  ADD CONSTRAINT `fk_StudentCurriculum_Curriculum1` FOREIGN KEY (`CurriculumID`) REFERENCES `curriculum` (`CurriculumID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentCurriculum_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentdocumentsubmission`
--
ALTER TABLE `studentdocumentsubmission`
  ADD CONSTRAINT `fk_StudentDocumentSubmission_DocumentRequirement1` FOREIGN KEY (`DocumentRequirementID`) REFERENCES `documentrequirement` (`DocumentRequirementID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentDocumentSubmission_Employee1` FOREIGN KEY (`EmployeeNo`) REFERENCES `employee` (`EmployeeNo`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentRequirement_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentinfo`
--
ALTER TABLE `studentinfo`
  ADD CONSTRAINT `fk_StudentInfo_Citizenship1` FOREIGN KEY (`CitizenshipID`) REFERENCES `citizenship` (`CitizenshipID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentInfo_Admission`
--
ALTER TABLE `StudentInfo_Admission`
  ADD CONSTRAINT `fk_StudentInfo_Admission_Citizenship1` FOREIGN KEY (`CitizenshipID`) REFERENCES `citizenship` (`CitizenshipID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentParentGuardian`
--
ALTER TABLE `StudentParentGuardian`
  ADD CONSTRAINT `fk_StudentParentGuardian_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentParentGuardian_TypeOfParentGuardian1` FOREIGN KEY (`TypeOfPGid`) REFERENCES `typeofparentguardian` (`TypeOfPGid`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `StudentProgramChoice`
--
ALTER TABLE `StudentProgramChoice`
  ADD CONSTRAINT `fk_StudentProgramChoice_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentProgramChoice_StudentInfo_Admission1` FOREIGN KEY (`StudentAdmissionID`) REFERENCES `StudentInfo_Admission` (`StudentAdmissionID`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `studentscholarship`
--
ALTER TABLE `studentscholarship`
  ADD CONSTRAINT `fk_StudentScholarship_Scholarship1` FOREIGN KEY (`ScholarshipID`) REFERENCES `scholarship` (`ScholarshipID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_StudentScholarship_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `student_assessment`
--
ALTER TABLE `student_assessment`
  ADD CONSTRAINT `fk_Student_Assessment_fees_StudentInfo1` FOREIGN KEY (`StudentID`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_College1` FOREIGN KEY (`CollegeID`) REFERENCES `college` (`CollegeID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_Program1` FOREIGN KEY (`ProgramID`) REFERENCES `program` (`ProgramID`) ON DELETE CASCADE ON UPDATE CASCADE,
  ADD CONSTRAINT `fk_Student_Assessment_fees_info_StudentInfo1` FOREIGN KEY (`StudentID`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE CASCADE ON UPDATE CASCADE;

--
-- Constraints for table `transaction`
--
ALTER TABLE `transaction`
  ADD CONSTRAINT `fk_Transaction_StudentInfo1` FOREIGN KEY (`StudentNo`) REFERENCES `studentinfo` (`StudentNo`) ON DELETE NO ACTION ON UPDATE NO ACTION;

--
-- Constraints for table `venueavailability`
--
ALTER TABLE `venueavailability`
  ADD CONSTRAINT `fk_RoomLabAvailability_AcademicTerm1` FOREIGN KEY (`AcademicTermID`) REFERENCES `AcademicTerm` (`AcademicTermID`) ON DELETE NO ACTION ON UPDATE NO ACTION,
  ADD CONSTRAINT `fk_RoomLabAvailability_RoomLab1` FOREIGN KEY (`VenueID`) REFERENCES `venue` (`VenueID`) ON DELETE NO ACTION ON UPDATE NO ACTION;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
